<!DOCTYPE html>
<html lang="en">
<?= $this->include('templates/head') ?>

<body>
<?php
$context = $ctx ?? '';
$sidebarColor = 'rose';
foreach ($sidebarMenus as $m) {
    if ($m['ctx'] === $context && !empty($m['sidebar_color'])) {
        $sidebarColor = $m['sidebar_color'];
        break;
    }
}
?>

<!-- Overlay for mobile sidebar -->
<div id="sidebarOverlay" class="sidebar-overlay d-lg-none"></div>

<!-- Sidebar -->
<nav id="sidebar" class="sidebar bg-dark text-white d-lg-block" data-color="<?= $sidebarColor ?>">
    <div class="sidebar-header d-flex justify-content-between align-items-center p-3">
        <b>SMAN 1 Cikatomas<br>2026</b>
        <button id="sidebarHideBtn" class="btn btn-sm btn-outline-light">❌</button>
    </div>
    <ul class="nav flex-column p-2 mb-2">
        <?php foreach ($sidebarMenus as $menu): ?>
            <?php 
            $active = ($context === $menu['ctx']) ? 'active' : '';
            $hasChildren = !empty($menu['children']);
            ?>
            <?php if ($hasChildren): ?>
                <li class="nav-item <?= $active ?>">
                    <a href="#submenu<?= $menu['ctx'] ?>" class="nav-link d-flex justify-content-between align-items-center py-2" data-bs-toggle="collapse">
                        <div class="d-flex align-items-center">
                            <i class="material-icons me-2"><?= esc($menu['icon']) ?></i>
                            <span class="menu-text"><?= esc($menu['label']) ?></span>
                        </div>
                        <i class="material-icons">expand_more</i>
                    </a>
                    <ul class="collapse list-unstyled ps-3 submenu">
                        <?php foreach ($menu['children'] as $child): ?>
                            <li>
                                <a class="nav-link text-white py-1" href="<?= base_url($child['url']) ?>"><?= esc($child['label']) ?></a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </li>
            <?php else: ?>
                <li class="nav-item <?= $active ?>">
                    <a class="nav-link d-flex align-items-center py-2" href="<?= base_url($menu['url']) ?>">
                        <i class="material-icons me-2"><?= esc($menu['icon']) ?></i>
                        <span class="menu-text"><?= esc($menu['label']) ?></span>
                    </a>
                </li>
            <?php endif; ?>
        <?php endforeach; ?>
    </ul>

</nav>

<!-- Sidebar Show Button -->
<button id="sidebarShowBtn" class="btn btn-primary position-fixed d-lg-block" style="top:10px; left:10px; z-index:1100;">☰</button>

<!-- Main Content -->
<div id="main" class="flex-grow-1">

    <!-- Navbar -->
    <nav id="navbar" class="navbar navbar-expand-lg navbar-transparent fixed-top shadow-lg" style="background: linear-gradient(90deg, #6a11cb, #2575fc); transition: top 0.3s; z-index:1030;">
        <div class="container-fluid">
            <!-- Mobile Hamburger Sidebar -->
            <button id="mobileSidebarBtn" class="btn btn-outline-light d-lg-none me-2">☰</button>

            <a class="navbar-brand text-white font-weight-bold" href="#"><?= $title; ?></a>

            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarMenu" aria-controls="navbarMenu" aria-expanded="false" aria-label="Toggle navigation">
                <span class="navbar-toggler-icon" style="color:white;"></span>
            </button>

            <div class="collapse navbar-collapse justify-content-end" id="navbarMenu">
                <ul class="navbar-nav">
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle text-white <?= user()->toArray()['is_superadmin'] == '1' ? 'text-warning' : ''; ?>" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="material-icons">person</i>
                            <span class="d-none d-lg-inline ml-1">User: <?= user()->toArray()['username']; ?></span>
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Content -->
    <div class="content pt-5 mt-4">
        <?= $this->renderSection('content') ?>
    </div>

    <?= $this->include('templates/footer') ?>
</div>

<!-- Scripts -->
<?= $this->include('templates/js') ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
const sidebar = document.getElementById('sidebar');
const sidebarHideBtn = document.getElementById('sidebarHideBtn');
const sidebarShowBtn = document.getElementById('sidebarShowBtn');
const mobileSidebarBtn = document.getElementById('mobileSidebarBtn');
const sidebarOverlay = document.getElementById('sidebarOverlay');

// Desktop sidebar hide/show with smooth slide
sidebarHideBtn.addEventListener('click', () => {
    sidebar.classList.add('sidebar-hidden');
    sidebarShowBtn.classList.remove('d-none');
});
sidebarShowBtn.addEventListener('click', () => {
    sidebar.classList.remove('sidebar-hidden');
    sidebarShowBtn.classList.add('d-none');
});

// Mobile sidebar toggle with smooth Material Dashboard animation
mobileSidebarBtn.addEventListener('click', () => {
    sidebar.classList.add('sidebar-mobile-show');
    sidebarOverlay.classList.add('show');
    document.body.style.overflow = 'hidden';
});
sidebarOverlay.addEventListener('click', () => {
    sidebar.classList.remove('sidebar-mobile-show');
    sidebarOverlay.classList.remove('show');
    document.body.style.overflow = 'auto';
});

// Submenu collapse toggle
document.querySelectorAll('#sidebar .nav-link[data-bs-toggle="collapse"]').forEach(link => {
    link.addEventListener('click', function() {
        const target = document.querySelector(this.getAttribute('href'));
        if (target.classList.contains('show')) {
            target.classList.remove('show');
        } else {
            target.classList.add('show');
        }
    });
});

// Navbar auto-hide
let prevScrollpos = window.pageYOffset;
const navbar = document.getElementById("navbar");
window.onscroll = function() {
    let currentScrollPos = window.pageYOffset;
    navbar.style.top = (prevScrollpos > currentScrollPos) ? "0" : "-80px";
    prevScrollpos = currentScrollPos;
};
</script>

<style>
#sidebar {
    width:220px; min-height:100vh; position:fixed; top:0; left:0; z-index:1040;
    background-color:#111; display:flex; flex-direction:column;
    transition: transform 0.4s cubic-bezier(0.4, 0, 0.2, 1);
}
#sidebar.sidebar-hidden { transform: translateX(-100%); }
#sidebar.sidebar-mobile-show { transform: translateX(0); }

#sidebar .nav-link { transition: all 0.3s ease; }
#sidebar .nav-link:hover { background-color: rgba(233,60,60,0.86); padding-left:1.5rem; }

#sidebar .submenu { transition: all 0.4s cubic-bezier(0.4,0,0.2,1); max-height:0; overflow:hidden; opacity:0; }
#sidebar .submenu.show { max-height:500px; opacity:1; }

#main { margin-left:220px; transition: margin-left 0.4s cubic-bezier(0.4,0,0.2,1); }
#sidebar.sidebar-hidden ~ #main { margin-left:0; }

@media(max-width:991px){
    #sidebar { transform: translateX(-100%); width:220px; z-index:1050; }
    #main { margin-left:0; }
    #sidebarShowBtn { display:none; }
}

.sidebar-overlay {
    position:fixed; top:0; left:0; width:100%; height:100%;
    background: rgba(0,0,0,0.5); z-index:1045; display:none;
    opacity:0; transition: opacity 0.3s ease;
}
.sidebar-overlay.show { display:block; opacity:1; }

.navbar-toggler { border-color:white; }
.navbar-toggler-icon { color:white; }
.menu-text { transition: transform 0.3s ease; }
#sidebar .nav-link:hover .menu-text { transform: translateX(5px); }

#sidebar .btn-danger { transition: all 0.3s ease; }
#sidebar .btn-danger:hover { transform: translateX(5px); background-color:#dc3545cc; }

/* === SCROLL SIDEBAR MENU (DESKTOP & MOBILE) === */
#sidebar {
    height: 100vh;          /* penuh layar */
    overflow: hidden;       /* header tetap */
}

#sidebar .nav {
    flex: 1;
    overflow-y: auto;       /* scroll menu */
    overflow-x: hidden;
}

/* scrollbar halus (opsional, aman di semua device) */
#sidebar .nav::-webkit-scrollbar {
    width: 6px;
}
#sidebar .nav::-webkit-scrollbar-thumb {
    background: rgba(255,255,255,0.3);
    border-radius: 10px;
}
#sidebar .nav::-webkit-scrollbar-track {
    background: transparent;
}




















/* === FIX SCROLL SIDEBAR DESKTOP & MOBILE === */
#sidebar {
    height: 100vh;
    overflow: hidden;
    display: flex;
    flex-direction: column;
}

/* header tetap */
#sidebar .sidebar-header {
    flex-shrink: 0;
}

/* AREA MENU YANG DISROLL */
#sidebar > ul.nav {
    flex: 1 1 auto;
    overflow-y: auto;
    overflow-x: hidden;
}

/* scrollbar halus */
#sidebar > ul.nav::-webkit-scrollbar {
    width: 6px;
}
#sidebar > ul.nav::-webkit-scrollbar-thumb {
    background: rgba(255,255,255,0.35);
    border-radius: 10px;
}
#sidebar > ul.nav::-webkit-scrollbar-track {
    background: transparent;
}
</style>
</body>
</html>
